Attribute VB_Name = "StartHere"
Option Explicit

'The template dialog id and control id's
Const IDD_DIALOG1 = 101
Const IDC_EDIT1 = 1000
Const IDC_CHECK1 = 1001
Const IDC_BUTTON1 = 1002
Const IDC_COMBO1 = 1003

Const IDCANCEL = 2


Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)
Private Declare Function GetDlgItem Lib "user32" (ByVal hDlg As Long, ByVal nIDDlgItem As Long) As Long
Private Declare Function GetClientRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long
Private Declare Function GetParent Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Any) As Long
Private Declare Function SendMessage2 Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long
Private Declare Function ShowWindow Lib "user32" (ByVal hwnd As Long, ByVal nCmdShow As Long) As Long
Private Declare Function SetDlgItemText Lib "user32" Alias "SetDlgItemTextA" (ByVal hDlg As Long, ByVal nIDDlgItem As Long, ByVal lpString As String) As Long
Private Declare Function SendMessageStr Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As String) As Long
Private Declare Function SendMessageLong Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function EnableWindow Lib "user32" (ByVal hwnd As Long, ByVal fEnable As Long) As Long
Private Declare Function FindWindowEx Lib "user32" Alias "FindWindowExA" (ByVal hWnd1 As Long, ByVal hWnd2 As Long, ByVal lpsz1 As String, ByVal lpsz2 As String) As Long
Private Declare Function CallWindowProc Lib "user32" Alias "CallWindowProcA" (ByVal lpPrevWndFunc As Long, ByVal hwnd As Long, ByVal Msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function DefDlgProc Lib "user32" Alias "DefDlgProcA" (ByVal hDlg As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Const GWL_WNDPROC = (-4)

Private Const DWL_DLGPROC = 4

Private Const SW_HIDE = 0
Private Const SW_SHOW = 5

Public DirFileList() As String

Private Const CDERR_FINDRESFAILURE = &H6
Private Const CDERR_LOADRESFAILURE = &H7
Private Const CDERR_NOTEMPLATE = &H3
Private Const CDERR_NOHOOK = &HB
Private Const CDERR_NOHINSTANCE = &H4

Private Const WM_COMMAND = &H111
Private Const WM_NOTIFY = &H4E
Private Const WM_SETICON = &H80
Private Const WM_USER = &H400
Private Const WM_INITDIALOG = &H110
Private Const WM_DESTROY = &H2
Private Const WM_NCDESTROY = &H82
Private Const WM_CLOSE = &H10
Private Const WM_QUIT = &H12

Private Const EN_CHANGE = &H300
Private Const EN_KILLFOCUS = &H200
Private Const EN_SETFOCUS = &H100

Private Const CB_INSERTSTRING = &H14A
Private Const CB_SETCURSEL = &H14E
Private Const CB_SETITEMDATA = &H151

Private Const FILEOKSTRING = "commdlg_FileNameOK"
Private Const LBSELCHSTRING = "commdlg_LBSelChangedNotify"

Private Const CDM_FIRST = (WM_USER + 100)
Private Const CDM_LAST = (WM_USER + 200)
Private Const CDM_GETSPEC = (CDM_FIRST + &H0)
Private Const CDM_GETFILEPATH = (CDM_FIRST + &H1)
Private Const CDM_GETFOLDERIDLIST = (CDM_FIRST + &H3)
Private Const CDM_GETFOLDERPATH = (CDM_FIRST + &H2)
Private Const CDM_HIDECONTROL = (CDM_FIRST + &H5)
Private Const CDM_SETCONTROLTEXT = (CDM_FIRST + &H4)
Private Const CDM_SETDEFEXT = (CDM_FIRST + &H6)

Private Const SW_SHOWNORMAL = 1
Private Const SPI_GETWORKAREA = 48

Public Const OFN_ALLOWMULTISELECT = &H200
Public Const OFN_CREATEPROMPT = &H2000
Public Const OFN_ENABLEHOOK = &H20
Public Const OFN_ENABLETEMPLATE = &H40
Public Const OFN_ENABLETEMPLATEHANDLE = &H80
Public Const OFN_EXPLORER = &H80000
Public Const OFN_EXTENSIONDIFFERENT = &H400
Public Const OFN_FILEMUSTEXIST = &H1000
Public Const OFN_HIDEREADONLY = &H4
Public Const OFN_LONGNAMES = &H200000
Public Const OFN_NOCHANGEDIR = &H8
Public Const OFN_NODEREFERENCELINKS = &H100000
Public Const OFN_NOLONGNAMES = &H40000
Public Const OFN_NONETWORKBUTTON = &H20000
Public Const OFN_NOREADONLYRETURN = &H8000
Public Const OFN_NOTESTFILECREATE = &H10000
Public Const OFN_NOVALIDATE = &H100
Public Const OFN_OVERWRITEPROMPT = &H2
Public Const OFN_PATHMUSTEXIST = &H800
Public Const OFN_READONLY = &H1
Public Const OFN_SHAREAWARE = &H4000
Public Const OFN_SHAREFALLTHROUGH = 2
Public Const OFN_SHARENOWARN = 1
Public Const OFN_SHAREWARN = 0
Public Const OFN_SHOWHELP = &H10
Public Const OFN_ENABLEINCLUDENOTIFY = &H400000

Const CDN_INITDONE = -601
Const CDN_SELCHANGE = -602
Const CDN_FOLDERCHANGE = -603
Const CDN_SHAREVIOLATION = -604
Const CDN_HELP = -605
Const CDN_FILEOK = -606
Const CDN_TYPECHANGE = -607
Const CDN_INCLUDEITEM = -608

Const ID_OPEN = &H1
Const ID_CANCEL = &H2
Const ID_HELP = &H40E
Const ID_READONLY = &H410
Const ID_FILETYPELABEL = &H441
Const ID_FILELABEL = &H442
Const ID_FOLDERLABEL = &H443
Const ID_LIST = &H461
Const ID_FORMAT = &H470
Const ID_FOLDER = &H471
Const ID_FILETEXT = &H480

Const BN_CLICKED = 0
Const CBN_CLOSEUP = 8
Const BM_GETCHECK = &HF0
Const CB_GETCURSEL = &H147
Const CB_GETITEMDATA = &H150


Private Type RECT
        Left As Long
        Top As Long
        Right As Long
        Bottom As Long
End Type

Private Type POINTAPI
        x As Long
        y As Long
End Type

Private Type NMHDR
    hwndFrom As Long
    idfrom As Long
    code As Long
End Type


Public Orig_DlgCtrlProc As Long
Public hwnd_DlgCtrl As Long
Public hwnd_Parent As Long




Sub StartDLG(OwnerHWnd As Long)
    Dim objCommonDialog As New clsCommonDialog
    Dim LoadFile As String
    
    
    With objCommonDialog
        .CancelError = True
        .HookAddress = pAddressOf(AddressOf SaveAsProc)
        .TemplateID = IDD_DIALOG1
        .Filter = "All Files|*.*"
        .DialogTitle = "Export As (Subclassed Common Dialog)"
        .DefaultExt = "exe"
        .FileName = "*.*"
        .flags = OFN_FILEMUSTEXIST Or _
                 OFN_SHOWHELP Or _
                 OFN_EXPLORER Or _
                 OFN_ENABLEHOOK Or _
                 OFN_ENABLETEMPLATE Or _
                 OFN_ENABLEINCLUDENOTIFY
        .FileTitle = ""
        .MaxFileSize = 150
        
        .cdLoadLibrary App.Path & "\DlgRes_VB.dll"
        .hInstance = App.hInstance
        
        .hOwner = OwnerHWnd
        .FilterIndex = 1
        
        .ShowSave
    End With
    
    
    'Get file name and path here when the common dialog box is closed
    '  This information can be obtained from the objCommonDialog.FileName
    '  and the objCommonDialog.FileTitle properties
    '
    'The Exporting routine would be here
    '
    'Remember to get the user selected delimiter from either the
    '  CBN_CLOSEUP combo-box message or the
    '  EN_KILLFOCUS text box message, depending on which one was currently visible
    '  when the common dialog was shutdown
    
    'Cleanup
    objCommonDialog.cdFreeLibrary
    Set objCommonDialog = Nothing
    LoadFile = objCommonDialog.FileName
End Sub


Function pAddressOf(ByVal ProcAddr As Long) As Long
    pAddressOf = ProcAddr
End Function


Public Function SaveAsProc(ByVal hwnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    Dim NMHStruct As NMHDR
    Dim lContext As Long
    Dim lTemp As Long
    Dim lNotificationCode As Long
    Dim lControlID As Long
    Dim hCtrl As Long
    Dim lRetVal As Long
    
    SaveAsProc = 0
    
    Select Case uMsg
        Case WM_INITDIALOG
            frmMain.txtMsg.Text = frmMain.txtMsg.Text & Hex$(hwnd) & "-WM_INITDIALOG" & vbNewLine
            frmMain.txtMsg.Text = frmMain.txtMsg.Text & "   Dialog modifications can occur here before it is shown" & vbNewLine
            DoEvents
            
            'Init the combo box items
            hCtrl = GetDlgItem(hwnd, IDC_COMBO1)
            lRetVal = SendMessageStr(hCtrl, CB_INSERTSTRING, 0&, "-")
            lRetVal = SendMessageLong(hCtrl, CB_SETITEMDATA, 0&, 0&)
            lRetVal = SendMessageStr(hCtrl, CB_INSERTSTRING, 1&, ";")
            lRetVal = SendMessageLong(hCtrl, CB_SETITEMDATA, 1&, 1&)
            lRetVal = SendMessageStr(hCtrl, CB_INSERTSTRING, 2&, ":")
            lRetVal = SendMessageLong(hCtrl, CB_SETITEMDATA, 2&, 2&)
            lRetVal = SendMessageStr(hCtrl, CB_INSERTSTRING, 3&, ",")
            lRetVal = SendMessageLong(hCtrl, CB_SETITEMDATA, 3&, 3&)
            lRetVal = SendMessageLong(hCtrl, CB_SETCURSEL, -1&, 0&)
        Case WM_NOTIFY
            frmMain.txtMsg.Text = frmMain.txtMsg.Text & "WM_NOTIFY -> "
            DoEvents

            CopyMemory NMHStruct, ByVal lParam, LenB(NMHStruct)

            Select Case NMHStruct.code
                Case CDN_INCLUDEITEM
                    frmMain.txtMsg.Text = frmMain.txtMsg.Text & Hex$(hwnd) & "-CDN_INCLUDEITEM" & vbNewLine
                    DoEvents
                Case CDN_INITDONE
                    frmMain.txtMsg.Text = frmMain.txtMsg.Text & Hex$(hwnd) & "-CDN_INITDONE" & vbNewLine
                    DoEvents
                Case CDN_SELCHANGE
                    frmMain.txtMsg.Text = frmMain.txtMsg.Text & Hex$(hwnd) & "-CDN_SELCHANGE" & vbNewLine
                    DoEvents
                Case CDN_FOLDERCHANGE
                    frmMain.txtMsg.Text = frmMain.txtMsg.Text & Hex$(hwnd) & "-CDN_FOLDERCHANGE" & vbNewLine
                    DoEvents
                Case CDN_HELP
                    frmMain.txtMsg.Text = frmMain.txtMsg.Text & Hex$(hwnd) & "-CDN_HELP" & vbNewLine
                    DoEvents
                Case CDN_FILEOK
                    frmMain.txtMsg.Text = frmMain.txtMsg.Text & Hex$(hwnd) & "-CDN_FILEOK" & vbNewLine
                    DoEvents
                Case CDN_SHAREVIOLATION
                    frmMain.txtMsg.Text = frmMain.txtMsg.Text & Hex$(hwnd) & "-CDN_SHAREVIOLATION" & vbNewLine
                    DoEvents
                Case CDN_TYPECHANGE
                    frmMain.txtMsg.Text = frmMain.txtMsg.Text & Hex$(hwnd) & "-CDN_TYPECHANGE" & vbNewLine
                    DoEvents
                Case Else
                    frmMain.txtMsg.Text = frmMain.txtMsg.Text & Hex$(hwnd) & "-" & CStr(uMsg) & "   " & vbNewLine
            End Select
        Case WM_COMMAND
            lNotificationCode = Get_HiWord(wParam)
            Select Case lNotificationCode
                Case EN_CHANGE
                    lControlID = Get_LoWord(wParam)
                    Select Case lControlID
                        Case IDC_EDIT1
                            frmMain.txtMsg.Text = frmMain.txtMsg.Text & Hex$(hwnd) & "-IDC_EDIT1 -> EN_CHANGED" & vbNewLine
                            DoEvents
                    End Select
                Case EN_KILLFOCUS
                    lControlID = Get_LoWord(wParam)
                    Select Case lControlID
                        Case IDC_EDIT1
                            frmMain.txtMsg.Text = frmMain.txtMsg.Text & Hex$(hwnd) & "-IDC_EDIT1 -> EN_KILLFOCUS" & vbNewLine
                            DoEvents
                    End Select
                Case EN_SETFOCUS
                    lControlID = Get_LoWord(wParam)
                    Select Case lControlID
                        Case IDC_EDIT1
                            frmMain.txtMsg.Text = frmMain.txtMsg.Text & Hex$(hwnd) & "-IDC_EDIT1 -> EN_SETFOCUS" & vbNewLine
                            DoEvents
                    End Select
                Case BN_CLICKED
                    lControlID = Get_LoWord(wParam)
                    Select Case lControlID
                        Case IDC_BUTTON1
                            frmMain.txtMsg.Text = frmMain.txtMsg.Text & Hex$(hwnd) & "-IDC_BUTTON1 -> BN_CLICKED" & vbNewLine
                            DoEvents
                            
                            'A message box is not a really good idea to have in a hook function
                            MsgBox "The button has been clicked!"
                        Case IDC_CHECK1
                            frmMain.txtMsg.Text = frmMain.txtMsg.Text & Hex$(hwnd) & "-IDC_CHECK1 -> BN_CLICKED" & vbNewLine
                            DoEvents
                            
                            'Do something to the UI
                            If CBool(SendMessageLong(lParam, BM_GETCHECK, 0&, 0&)) Then
                                hCtrl = GetDlgItem(hwnd, IDC_EDIT1)
                                Call ShowWindow(hCtrl, SW_HIDE)
                                
                                hCtrl = GetDlgItem(hwnd, IDC_COMBO1)
                                Call ShowWindow(hCtrl, SW_SHOW)
                            Else
                                hCtrl = GetDlgItem(hwnd, IDC_COMBO1)
                                Call ShowWindow(hCtrl, SW_HIDE)
                                
                                hCtrl = GetDlgItem(hwnd, IDC_EDIT1)
                                Call ShowWindow(hCtrl, SW_SHOW)
                            End If
                    End Select
                Case CBN_CLOSEUP
                    lControlID = Get_LoWord(wParam)
                    Select Case lControlID
                        Case IDC_COMBO1
                            frmMain.txtMsg.Text = frmMain.txtMsg.Text & Hex$(hwnd) & "-IDC_COMBO1 -> CBN_CLOSEUP" & vbNewLine
                            DoEvents
                    End Select
                Case Else
                    frmMain.txtMsg.Text = frmMain.txtMsg.Text & "Unhandled notification message - " & vbNewLine
                    DoEvents
            End Select
        Case WM_DESTROY
            frmMain.txtMsg.Text = frmMain.txtMsg.Text & Hex$(hwnd) & "-WM_DESTROY" & vbNewLine
        Case WM_NCDESTROY
            frmMain.txtMsg.Text = frmMain.txtMsg.Text & Hex$(hwnd) & "-WM_NCDESTROY" & vbNewLine
    End Select
End Function


Public Function Get_HiWord(ByRef lThis As Long) As Long
   If (lThis And &H80000000) = &H80000000 Then
      Get_HiWord = ((lThis And &H7FFF0000) \ &H10000) Or &H8000&
   Else
      Get_HiWord = (lThis And &HFFFF0000) \ &H10000
   End If
End Function

Public Sub Set_HiWord(ByRef lThis As Long, ByVal lHiWord As Long)
   If (lHiWord And &H8000&) = &H8000& Then
      lThis = lThis And Not &HFFFF0000 Or ((lHiWord And &H7FFF&) * &H10000) Or &H80000000
   Else
      lThis = lThis And Not &HFFFF0000 Or (lHiWord * &H10000)
   End If
End Sub

Public Function Get_LoWord(ByRef lThis As Long) As Long
   Get_LoWord = (lThis And &HFFFF&)
End Function

Public Sub Set_LoWord(ByRef lThis As Long, ByVal lLoWord As Long)
   lThis = lThis And Not &HFFFF& Or lLoWord
End Sub


